#!/usr/local/bin/python
# -*- coding: utf-8 -*-
import os, sys, site 
import re, urllib
import datetime, time
import shutil

sys.path.append( os.path.dirname(__file__) )
curdir = os.path.dirname(__file__)

#SAKURA SERVERで必要な環境設定(VPSはコメントアウトする)
site.addsitedir(os.path.expanduser("_site-packages" ))

from config import *

from bs4 import BeautifulSoup
import sqlite3dbm
from sqlobject import *

import web
web.ctx.homepath = '' 
web.config.debug = DEBUG 

from utils import *

#TEMPLATE FOLDER 確認
if not os.path.exists(PANEO_SITE_DATA_DIR) :
    os.mkdir(PANEO_SITE_DATA_DIR)
if not os.path.exists(PANEO_SITE_DATA_DB_DIR) :
    os.mkdir(PANEO_SITE_DATA_DB_DIR)

if not os.path.exists(PANEO_SITE_DATA_DIR+'img/') :
    os.mkdir(PANEO_SITE_DATA_DIR+'img/')
if not os.path.exists(PANEO_SITE_DATA_DIR+'backup/') :
    os.mkdir(PANEO_SITE_DATA_DIR+'backup/')
if not os.path.exists(PANEO_SITE_DATA_DIR+'cache/') :
    os.mkdir(PANEO_SITE_DATA_DIR+'cache/')
if not os.path.exists(PANEO_SITE_DATA_DIR+'tmp/') :
    os.mkdir(PANEO_SITE_DATA_DIR+'tmp/')

#OLD PANEODB MOVE
#if not os.path.exists(PANEO_DB):
#    shutil.copyfile(PANEO_SITE_DATA_DIR+'paneodb.sqlite3',PANEO_DB)

#ARTILCE IMG FOLDER
if not os.path.exists(PANEO_SITE_DATA_DIR+'img/articles/') :
    os.mkdir(PANEO_SITE_DATA_DIR+'img/articles/')
for a in ARTICLES:
    if not os.path.exists(PANEO_SITE_DATA_DIR+'img/articles/'+a.get('prefix')+'/') :
        os.mkdir(PANEO_SITE_DATA_DIR+'img/articles/'+a.get('prefix')+'/')

#ARTILCES CREATE DB
sqlhub.processConnection = connectionForURI('sqlite://'+ARTICLES_DB)
ArticlesType.createTable(ifNotExists=True)
Articles.createTable(ifNotExists=True)
Posts.createTable(ifNotExists=True)
Groups.createTable(ifNotExists=True)
Categories.createTable(ifNotExists=True)
#PostsCategories.createTable(ifNotExists=True)

#ARTICLE DB CHECK
for t in ARTICLES_TYPE:
    articlestype = ArticlesType.select(ArticlesType.q.prefix == t.get("prefix")).getOne(default=None)
    if not articlestype:
        ArticlesType(   prefix = t.get('prefix'),
                        title = t.get('title'),
                        idx = t.get('idx'),
        )
        articlestype = ArticlesType.select(ArticlesType.q.prefix == t.get("prefix")).getOne(default=None)
    else:
        articlestype.title = t.get('title')
        articlestype.idx = t.get('idx')

for a in ARTICLES:
    articlestype = ArticlesType.select(ArticlesType.q.prefix == a.get("type")).getOne(default=None)
    article = Articles.select(Articles.q.prefix == a.get("prefix")).getOne(default=None)
    if not article:
        Articles(   prefix = a.get('prefix'),
                    type = articlestype.id,
                    title = a.get('title'),
                    template_set = a.get('template_set'),
                    password = a.get('password'),
        )
        article = Articles.select(Articles.q.prefix == a.get("prefix")).getOne(default=None)
    else:
        article.title = a.get('title')
        article.template_set = a.get('template_set')
        article.password = a.get('password')

    #初期TEMPALTE COPY
    tempdir = os.path.join( PANEO_ROOT, './paneo_page_templates/' + article.template_set + '/').replace('\\','/')
    ptmps = glob.glob( tempdir + '*.html')
    artdir = PANEO_SITE_DATA_DIR+'/__art__'+article.prefix + '__' + article.template_set + '__'
    for f in ptmps:
        fname = os.path.split(f)[1]
        if not os.path.exists(artdir+fname):
            shutil.copyfile(f,artdir+fname)


def dummypost():
    #Posts.select( Posts.q.articles == article ).limit(10) 
    #DUMMY POST
    file = codecs.open(PANEO_SITE_DATA_DIR+'index.html',"r","utf8")
    html_file=file.read()
    file.close()
    for a in ARTICLES:
        article = Articles.select(Articles.q.prefix == a.get("prefix")).getOne(default=None)
        if len(article.posts) == 0:
            for i in range(1,2001):
                posts = Posts(  
                    articles = article.id, 
                    slug = ("post_%s_%s" % (article.prefix,i)),
                    title = u"%sのダミー記事 %s" % ( article.title , i ), 
                    groups = None,
                    password = "",
                    template = 'skelton',
                    contents = {
                        'html':html_file,
                    }
                    #date = DateTimeCol(notNone=1,default=DateTimeCol.now)
                    #contents = PickleCol()
                    #rawtext = UnicodeCol()
                    #groups = ForeignKey('Groups',notNone=1)
                    #categories = RelatedJoin('Categories')
                    #label1 = UnicodeCol()
                    #label2 = UnicodeCol()
                    #label3 = UnicodeCol()
                    #viewed = BoolCol(notNone=1, default=True)
                    #created = DateTimeCol(notNone=1,default=DateTimeCol.now)
                )

#sqlhub.doInTransaction(dummypost)



#SESSION SQLite準備
import sqlite3
con = sqlite3.connect(SESSION_DB,isolation_level=None)

sessions_sql = """
CREATE TABLE sessions (
    session_id TEXT UNIQUE NOT NULL,
    atime TIMESTAMP,
    data TEXT
);
"""
cur = con.execute("SELECT * FROM sqlite_master WHERE type='table' and name='sessions'")
if cur.fetchone() == None: 
    con.execute(sessions_sql)
    con.commit()
con.close() 

#web.py URL MAPPING
urls = (

    '/formmail_(.*)_err\.html',     '_page.pfm.Err',             
    '/formmail_(.*)_thax\.html',    '_page.pfm.Thanx',             
    '/formmail_(.*)_conf\.html',    '_page.pfm.Conf',             
    '/formmail_(.*)\.html',         '_page.pfm.Entry',             

    '/paneo/articles/(.*)/edit/ID(.*)/','_cms.articles.PostEdit',
    '/paneo/articles/(.*)/p(.*)/',   '_cms.articles.View',
    '/paneo/articles/(.*)/',         '_cms.articles.View',

    '/paneo/ecaws/edit/(.*)/',      '_cms.ecaws.Edit',
    '/paneo/ecaws/',                '_cms.ecaws.View',

    '/paneo/background/edit/(.*)/',  '_cms.background.Edit',
    '/paneo/background/',            '_cms.background.View',

    '/paneo/images/edit/(.*)/',     '_cms.images.Edit',
    '/paneo/images/',               '_cms.images.View',

    '/paneo/contents/edit/(.*)/',   '_cms.contents.Edit',
    '/paneo/contents/',             '_cms.contents.View',

    '/paneo/pages/edit/(.*)/',      '_cms.pages.Edit',
    '/paneo/pages/new/',            '_cms.pages.New',
    '/paneo/pages/',                '_cms.pages.View',

    '/paneo/files/edit/(.*)/',      '_cms.pfiles.Edit',
    '/paneo/files/',                '_cms.pfiles.View',

    '/paneo/formmail/edit/(.*)/(.*)/','_cms.formmail.Edit',
    '/paneo/formmail/form/(.*)/',   '_cms.formmail.View',
    '/paneo/formmail/new/',         '_cms.formmail.New',
    '/paneo/formmail/',             '_cms.formmail.List',

    '/paneo/tumblr/',               '_cms.tumblr.View',

    '/paneo/logout/',               '_cms.login.Logout',
    '/paneo/login/',                '_cms.login.View',
    '/paneo/',                      '_cms.home.View',

    '/paneo.epub',                 '_page.epub.Make',
    '/site.appcache',              '_page.AppCache',
    '/img/(.*)/(.*)/',             '_page.ViewImage',
    '/img/(.*)/?',                 '_page.ViewImage',
    '/(.*)\.css',                   '_page.ViewCSS',             
    '/(.*)\.html',                  '_page.ViewHTML',             

    '/',                            '_page.ViewHTML',
)

#web.py app setting
app = web.application(urls, globals())

db = web.database(dbn='sqlite', db=SESSION_DB)
store = web.session.DBStore(db, 'sessions')
session = web.session.Session(  app, 
                                store,
                                initializer={ 
                                    'loggedin':False,
                                    'admin':False,
                                    'count': 0, 
                                  }, )

#Shelve
dic = sqlite3dbm.sshelve.open(PANEO_DB)

#PASSWORD
if dic.get('admin_password') is None :
    dic['admin_password'] = ADMIN_PASSWORD 
else:
    if dic.get('admin_password') != ADMIN_PASSWORD :
        dic['admin_password'] = ADMIN_PASSWORD 
if dic.get('user_password') is None :
    dic['user_password'] = USER_PASSWORD 
else:
    if dic.get('user_password') != ADMIN_PASSWORD :
        dic['user_password'] = USER_PASSWORD 

#PANEO SITECONFIG
if dic.get('siteconfig') is None :
    scfg = {}
    scfg['SITENAME'] = u'サイト名を入力してください'
    scfg['PAGEMAKE'] = u'CMS'
    dic['siteconfig'] = scfg 

#PANEO PAGES
if dic.get('pages') is None :
    pages = {} 
    p = {}
    p['IDX'] = 0 
    p['TYPE'] = 'MENU' 
    p['PARENT'] = ''
    p['TEMPLATE'] = 'skelton'
    p['TITLE'] = u'HOME'
    p['LINK'] = ''
    pages['index']=p
    dic['pages'] = pages

    #index page
    index_temp =  os.path.join( PANEO_ROOT , 'paneo_page_templates/skelton.html').replace('\\','/')
    if not os.path.exists(PANEO_SITE_DATA_DIR+'index.html'):
        shutil.copyfile(PANEO_CMS_PAGE_TEMPLATES_DIR+'skelton.html', PANEO_SITE_DATA_DIR + 'index.html')

#PANEO FILEDS
if dic.get('fields') is None:
    dic['fields'] = {}

dic.close()


def session_hook():
    web.ctx.session = session
    #web.ctx.paneodb = paneodb 
app.add_processor(web.loadhook(session_hook))

#PANEO AUTH
def auth_app_processor(handle):
    if str( web.ctx.path ).startswith("/paneo/"):
        if not str( web.ctx.path ).startswith("/paneo/login/"):
            if not web.ctx.session.get('loggedin') :
                raise web.seeother('http://' + web.ctx.host + '/paneo/login/')
    return handle()

app.add_processor(auth_app_processor)

def notfound():
    return web.notfound("Sorry, the page you were looking for was not found.")
app.notfound = notfound

from mako.template import Template
class hello:
    def GET(self):
        return Template("hello ${data} paneo!").render(data="world")

application = app.wsgifunc()

if __name__ == "__main__":
    app.run()

